<?php
/*
Plugin Name: Bible Verse of the Day
Plugin URI: http://wordpress.org/plugins/bible-verse-of-the-day/
Description: The daily Bible verse or a random Bible verse on your website, from DailyVerses.net
Version: 2.6
Author: DailyVerses.net
Author URI: https://dailyverses.net
Text Domain: bible-verse-of-the-day
License: GPL2

  Copyright 2020  DailyVerses.net  (email : mail@dailyverses.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as 
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

function prefix_add_my_stylesheet() {
	wp_register_style( 'prefix-style', plugins_url('bible-verse-of-the-day.css', __FILE__) );
	wp_enqueue_style( 'prefix-style' );
}

add_action( 'wp_enqueue_scripts', 'prefix_add_my_stylesheet' );

function bible_verse_of_the_day_load_plugin_textdomain() {
    load_plugin_textdomain( 'bible-verse-of-the-day', FALSE, basename( dirname( __FILE__ ) ) . '/languages/' );
}

add_action( 'plugins_loaded', 'bible_verse_of_the_day_load_plugin_textdomain' );

function bible_verse_of_the_day($showlink, $language='en') 
{
	if ($language == '')
	{
		$language == 'en';
	}
	
	$languageAdd = get_language_add($language);
	$languageUrl = get_language_url($language);
	
	$bibleVerseOfTheDay_Date = get_option('bibleVerseOfTheDay_Date' . $languageAdd);
	$bibleVerseOfTheDay_bibleVerse = get_option('bibleVerseOfTheDay_Verse' . $languageAdd);
	$bibleVerseOfTheDay_lastAttempt = get_option('bibleVerseOfTheDay_LastAttempt' . $languageAdd);
				
	$bibleVerseOfTheDay_currentDate = date('Y-m-d');

	if($bibleVerseOfTheDay_Date != $bibleVerseOfTheDay_currentDate && $bibleVerseOfTheDay_lastAttempt < (date('U') - 3600))
	{
		$url = 'http://dailyverses.net/get/verse?language=' . $language . '&date=' . $bibleVerseOfTheDay_currentDate . '&url=' . $_SERVER['HTTP_HOST'] . '&type=daily2_6';
		$result = wp_remote_get($url);

		update_option('bibleVerseOfTheDay_LastAttempt' . $languageAdd, date('U'));
		
		if(!is_wp_error($result)) 
		{
			$bibleVerseOfTheDay_bibleVerse = str_replace(',', '&#44;', $result['body']);

			update_option('bibleVerseOfTheDay_Date' . $languageAdd, $bibleVerseOfTheDay_currentDate);
			update_option('bibleVerseOfTheDay_Verse' . $languageAdd, $bibleVerseOfTheDay_bibleVerse);
		}
	}

	if($bibleVerseOfTheDay_bibleVerse == "")
	{
		$bibleVerseOfTheDay_bibleVerse = get_default_verse($language);
	}

    if($showlink == 'true' || $showlink == '1')
	{
		$html =  $bibleVerseOfTheDay_bibleVerse . '<div class="dailyVerses linkToWebsite"><a href="https://dailyverses.net' . $languageUrl . '" target="_blank" rel="noopener">DailyVerses.net</a></div>';
	}
	else
	{
		$html = $bibleVerseOfTheDay_bibleVerse;
	}
	
	return $html;
}

function random_bible_verse($showlink, $language='en') 
{
	if ($language == '')
	{
		$language == 'en';
	}
	
	$languageAdd = get_language_add($language);
	$languageUrl = get_language_url($language);

	$position = rand(0, 400);
	$randomBibleVerse = get_option('randomBibleVerse_' . $position . $languageAdd);
	$randomBibleVerse_lastAttempt = get_option('randomBibleVerse_LastAttempt' . $languageAdd);
	
	if($randomBibleVerse == "" && $randomBibleVerse_lastAttempt < (date('U') - 3600))
	{
		$url = 'http://dailyverses.net/get/random?language=' . $language . '&position=' . $position . '&url=' . $_SERVER['HTTP_HOST'] . '&type=random2_6';
		$result = wp_remote_get($url);

		if(!is_wp_error($result)) 
		{
			$randomBibleVerse = str_replace(',', '&#44;', $result['body']);

			update_option('randomBibleVerse_' . $position . $languageAdd, $randomBibleVerse);
		}
		else
		{
			update_option('randomBibleVerse_LastAttempt' . $languageAdd, date('U'));
		}
	}

	if($randomBibleVerse == "")
	{
		$randomBibleVerse = get_default_verse($language);
	}
		
	if($showlink == 'true' || $showlink == '1')
	{
		$html = $randomBibleVerse . '<div class="dailyVerses linkToWebsite"><a href="https://dailyverses.net' . $languageUrl . '" target="_blank" rel="noopener">DailyVerses.net</a></div>';
	}
	else
	{
		$html = $randomBibleVerse;
	}
	
	return $html;
}

function get_default_verse($language)
{
	if($language == "kjv")
	{
		return '<div class="dailyVerses bibleText">For God so loved the world, that he gave his only begotten Son, that whosoever believeth in him should not perish, but have everlasting life.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/john/3/16/kjv" target="_blank" rel="noopener">John 3:16</a></div>';
	}	
	else if($language == "esv")
	{
		return '<div class="dailyVerses bibleText">For God so loved the world, that he gave his only Son, that whoever believes in him should not perish but have eternal life.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/john/3/16/esv" target="_blank" rel="noopener">John 3:16</a></div>';
	}
	else if($language == "nl" || $language == "nbv")
	{
		return '<div class="dailyVerses bibleText">Want God had de wereld zo lief dat hij zijn enige Zoon heeft gegeven, opdat iedereen die in hem gelooft niet verloren gaat, maar eeuwig leven heeft.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/nl/johannes/3/16" target="_blank" rel="noopener">Johannes 3:16</a></div>';
	}
	else if($language == "bgt")
	{
		return '<div class="dailyVerses bibleText">Want Gods liefde voor de mensen was zo groot, dat hij zijn enige Zoon gegeven heeft. Iedereen die in hem gelooft, zal niet sterven, maar voor altijd leven.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/nl/johannes/3/16/bgt" target="_blank" rel="noopener">Johannes 3:16</a></div>';
	}
	else if($language == "nbg")
	{
		return '<div class="dailyVerses bibleText">Want alzo lief heeft God de wereld gehad, dat Hij zijn eniggeboren Zoon gegeven heeft, opdat een ieder, die in Hem gelooft, niet verloren ga, maar eeuwig leven hebbe.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/nl/johannes/3/16/nbg" target="_blank" rel="noopener">Johannes 3:16</a></div>';
	}
	else if($language == "bb")
	{
		return '<div class="dailyVerses bibleText">Want God houdt zoveel van de mensen, dat Hij zijn enige Zoon aan hen heeft gegeven. Iedereen die in Hem gelooft, zal niet verloren gaan, maar zal het eeuwige leven hebben.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/nl/johannes/3/16/bb" target="_blank" rel="noopener">Johannes 3:16</a></div>';
	}
	else if($language == "es" || $language == "nvi")
	{
		return '<div class="dailyVerses bibleText">Porque tanto amó Dios al mundo, que dio a su Hijo unigénito, para que todo el que cree en él no se pierda, sino que tenga vida eterna.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/es/juan/3/16" target="_blank" rel="noopener">Juan 3:16</a></div>';
	}
	else if($language == "rvr60")
	{
		return '<div class="dailyVerses bibleText">Porque de tal manera amó Dios al mundo, que ha dado a su Hijo unigénito, para que todo aquel que en él cree, no se pierda, mas tenga vida eterna.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/es/juan/3/16/rvr60" target="_blank" rel="noopener">Juan 3:16</a></div>';
	}
	else if($language == "rvr95")
	{
		return '<div class="dailyVerses bibleText">De tal manera amó Dios al mundo, que ha dado a su Hijo unigénito, para que todo aquel que en él cree no se pierda, sino que tenga vida eterna.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/es/juan/3/16/rvr95" target="_blank" rel="noopener">Juan 3:16</a></div>';
	}
	else if($language == "de" || $language == "lut")
	{
		return '<div class="dailyVerses bibleText">Denn also hat Gott die Welt geliebt, dass er seinen eingeborenen Sohn gab, damit alle, die an ihn glauben, nicht verloren werden, sondern das ewige Leben haben.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/de/johannes/3/16" target="_blank" rel="noopener">Johannes 3:16</a></div>';
	}	
	else if($language == "neu")
	{
		return '<div class="dailyVerses bibleText">Denn so hat Gott der Welt seine Liebe gezeigt: Er gab seinen einzigen Sohn dafür, dass jeder, der an ihn glaubt, nicht ins Verderben geht, sondern ewiges Leben hat.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/de/johannes/3/16/neu" target="_blank" rel="noopener">Johannes 3:16</a></div>';
	}	
	else if($language == "elb")
	{
		return '<div class="dailyVerses bibleText">Denn so hat Gott die Welt geliebt, dass er seinen eingeborenen Sohn gab, damit jeder, der an ihn glaubt, nicht verloren geht, sondern ewiges Leben hat.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/de/johannes/3/16/elb" target="_blank" rel="noopener">Johannes 3:16</a></div>';
	}
	else if($language == "pt" || $language == "arc")
	{
		return '<div class="dailyVerses bibleText">Porque Deus amou o mundo de tal maneira que deu o seu Filho unigênito, para que todo aquele que nele crê não pereça, mas tenha a vida eterna.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/pt/joao/3/16" target="_blank" rel="noopener">João 3:16</a></div>';
	}
	else if($language == "sk" || $language == "kat")
	{
		return '<div class="dailyVerses bibleText">Veď Boh tak miloval svet, že dal svojho jednorodeného Syna, aby nezahynul nik, kto v neho verí, ale aby mal večný život.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/sk/jan/3/16" target="_blank" rel="noopener">Ján 3:16</a></div>';
	}	
	else if($language == "it" || $language == "cei")
	{
		return '<div class="dailyVerses bibleText">Dio infatti ha tanto amato il mondo da dare il suo Figlio unigenito, perché chiunque crede in lui non muoia, ma abbia la vita eterna.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/it/giovanni/3/16" target="_blank" rel="noopener">Giovanni 3:16</a></div>';
	}
	else if($language == "fr" || $language == "sg21")
	{
		return '<div class="dailyVerses bibleText">En effet, Dieu a tant aimé le monde qu&apos;il a donné son Fils unique afin que quiconque croit en lui ne périsse pas mais ait la vie éternelle.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/fr/jean/3/16" target="_blank" rel="noopener">Jean 3:16</a></div>';
	}
	else if($language == "fi" || $language == "kr92")
	{
		return '<div class="dailyVerses bibleText">Jumala on rakastanut maailmaa niin paljon, että antoi ainoan Poikansa, jottei yksikään, joka häneen uskoo, joutuisi kadotukseen, vaan saisi iankaikkisen elämän.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/fi/johannes/3/16" target="_blank" rel="noopener">Johannes 3:16</a></div>';
	}
	else if($language == "cuv")
	{
		return '<div class="dailyVerses bibleText">神 愛 世 人 ， 甚 至 將 他 的 獨 生 子 賜 給 他 們 ， 叫 一 切 信 他 的 ， 不 至 滅 亡 ， 反 得 永 生 。</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/tc/%e7%b4%84%e7%bf%b0%e7%a6%8f%e9%9f%b3/3/16" target="_blank" rel="noopener">約 翰 福 音 3:16</a></div>';
	}
	else if($language == "avd")
	{
		return '<div class="dailyVerses bibleText">لِأَنَّهُ هَكَذَا أَحَبَّ ٱللهُ ٱلْعَالَمَ حَتَّى بَذَلَ ٱبْنَهُ ٱلْوَحِيدَ، لِكَيْ لَا يَهْلِكَ كُلُّ مَنْ يُؤْمِنُ بِهِ، بَلْ تَكُونُ لَهُ ٱلْحَيَاةُ ٱلْأَبَدِيَّةُ.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/ar/%d9%8a%d9%8f%d9%88%d8%ad%d9%8e%d9%86%d9%91%d9%8e%d8%a7/3/16" target="_blank" rel="noopener">يُوحَنَّا ٣: ١٦</a></div>';
	}

	//niv
	return '<div class="dailyVerses bibleText">For God so loved the world that he gave his one and only Son, that whoever believes in him shall not perish but have eternal life.</div><div class="dailyVerses bibleVerse"><a href="https://dailyverses.net/john/3/16" target="_blank" rel="noopener">John 3:16</a></div>';
}

function get_language_add($language)
{
	$languageAdd = '';
	
	if($language == 'nl' || $language == 'nbv' || $language == 'bgt' || $language == 'nbg' || $language == 'bb')
	{
		if($language == 'nl') $languageAdd = '_nl';
		else if($language == 'nbv') $languageAdd = '_nbv';
		else if($language == 'bgt') $languageAdd = '_bgt';
		else if($language == 'nbg') $languageAdd = '_nbg';
		else if($language == 'bb') $languageAdd = '_bb';
	}
	else if($language == 'es' || $language == 'nvi' || $language == 'rvr60' || $language == 'rvr95')
	{
		if($language == 'es') $languageAdd = '_es';
		else if($language == 'nvi') $languageAdd = '_nvi';
		else if($language == 'rvr60') $languageAdd = '_rvr60';
		else if($language == 'rvr95') $languageAdd = '_rvr95';
	}
	else if($language == 'de' || $language == 'lut' || $language == 'neu' || $language == 'elb')
	{
		if($language == 'de') $languageAdd = '_de';
		else if($language == 'lut') $languageAdd = '_lut';
		else if($language == 'neu') $languageAdd = '_neu';
		else if($language == 'elb') $languageAdd = '_elb';
	}
	else if($language == 'pt' || $language == 'arc')
	{
		if($language == 'pt') $languageAdd = '_pt';
		else if($language == 'arc') $languageAdd = '_arc';
	}
	else if($language == 'sk' || $language == 'kat')
	{
		if($language == 'sk') $languageAdd = '_sk';
		else if($language == 'kat') $languageAdd = '_kat';
	}
	else if($language == 'it' || $language == 'cei')
	{
		if($language == 'it') $languageAdd = '_it';
		else if($language == 'cei') $languageAdd = '_cei';
	}
	else if($language == 'fr' || $language == 'sg21')
	{
		if($language == 'fr') $languageAdd = '_fr';
		else if($language == 'sg21') $languageAdd = '_sg21';
	}
	else if($language == 'fi' || $language == 'kr92')
	{
		if($language == 'fi') $languageAdd = '_fi';
		else if($language == 'kr92') $languageAdd = '_kr92';
	}
	else if($language == 'cuv')
	{
		$languageAdd = '_cuv';
	}
	else if($language == 'avd')
	{
		$languageAdd = '_avd';
	}
	else
	{
		if($language == 'niv') $languageAdd = '_niv';
		else if($language == 'kjv') $languageAdd = '_kjv';
		else if($language == 'esv') $languageAdd = '_esv';
	}
	
	return $languageAdd;
}

function get_language_url($language)
{
	if($language == 'nl' || $language == 'nbv' || $language == 'bgt' || $language == 'nbg' || $language == 'bb')
	{
		return '/nl';
	}
	else if($language == 'es' || $language == 'nvi' || $language == 'rvr60' || $language == 'rvr95')
	{
		return '/es';
	}
	else if($language == 'de' || $language == 'lut' || $language == 'neu' || $language == 'elb')
	{
		return '/de';
	}
	else if($language == 'pt' || $language == 'arc')
	{
		return '/pt';
	}
	else if($language == 'sk' || $language == 'kat')
	{
		return '/sk';
	}
	else if($language == 'it' || $language == 'cei')
	{
		return '/it';
	}
	else if($language == 'fr' || $language == 'sg21')
	{
		return '/fr';
	}
	else if($language == 'fi' || $language == 'kr92')
	{
		return '/fi';
	}
	else if($language == 'cuv')
	{
		return '/tc';
	}
	else if($language == 'avd')
	{
		return '/ar';
	}
	
	return '';
}

//en
add_shortcode('bibleverseoftheday', 'bible_verse_of_the_day_niv'); 
add_shortcode('randombibleverse', 'random_bible_verse_niv'); 
add_shortcode('bibleverseoftheday_en', 'bible_verse_of_the_day_niv'); 
add_shortcode('randombibleverse_en', 'random_bible_verse_niv'); 
add_shortcode('bibleverseoftheday_niv', 'bible_verse_of_the_day_niv'); 
add_shortcode('randombibleverse_niv', 'random_bible_verse_niv'); 
add_shortcode('bibleverseoftheday_kjv', 'bible_verse_of_the_day_kjv'); 
add_shortcode('randombibleverse_kjv', 'random_bible_verse_kjv'); 
add_shortcode('bibleverseoftheday_esv', 'bible_verse_of_the_day_esv'); 
add_shortcode('randombibleverse_esv', 'random_bible_verse_esv'); 

//nl
add_shortcode('bibleverseoftheday_nl', 'bible_verse_of_the_day_nl'); 
add_shortcode('randombibleverse_nl', 'random_bible_verse_nl'); 
add_shortcode('bibleverseoftheday_nbv', 'bible_verse_of_the_day_nl'); 
add_shortcode('randombibleverse_nbv', 'random_bible_verse_nl'); 
add_shortcode('bibleverseoftheday_bgt', 'bible_verse_of_the_day_bgt'); 
add_shortcode('randombibleverse_bgt', 'random_bible_verse_bgt'); 
add_shortcode('bibleverseoftheday_nbg', 'bible_verse_of_the_day_nbg'); 
add_shortcode('randombibleverse_nbg', 'random_bible_verse_nbg'); 
add_shortcode('bibleverseoftheday_bb', 'bible_verse_of_the_day_bb'); 
add_shortcode('randombibleverse_bb', 'random_bible_verse_bb'); 

//es
add_shortcode('bibleverseoftheday_es', 'bible_verse_of_the_day_es'); 
add_shortcode('randombibleverse_es', 'random_bible_verse_es'); 
add_shortcode('bibleverseoftheday_nvi', 'bible_verse_of_the_day_es'); 
add_shortcode('randombibleverse_nvi', 'random_bible_verse_es'); 
add_shortcode('bibleverseoftheday_rvr60', 'bible_verse_of_the_day_rvr60'); 
add_shortcode('randombibleverse_rvr60', 'random_bible_verse_rvr60'); 
add_shortcode('bibleverseoftheday_rvr95', 'bible_verse_of_the_day_rvr95'); 
add_shortcode('randombibleverse_rvr95', 'random_bible_verse_rvr95'); 

//de
add_shortcode('bibleverseoftheday_de', 'bible_verse_of_the_day_lut'); 
add_shortcode('randombibleverse_de', 'random_bible_verse_lut'); 
add_shortcode('bibleverseoftheday_lut', 'bible_verse_of_the_day_lut'); 
add_shortcode('randombibleverse_lut', 'random_bible_verse_lut'); 
add_shortcode('bibleverseoftheday_neu', 'bible_verse_of_the_day_neu'); 
add_shortcode('randombibleverse_neu', 'random_bible_verse_neu'); 
add_shortcode('bibleverseoftheday_elb', 'bible_verse_of_the_day_elb'); 
add_shortcode('randombibleverse_elb', 'random_bible_verse_elb'); 

//pt
add_shortcode('bibleverseoftheday_pt', 'bible_verse_of_the_day_pt'); 
add_shortcode('randombibleverse_pt', 'random_bible_verse_pt'); 
add_shortcode('bibleverseoftheday_arc', 'bible_verse_of_the_day_arc'); 
add_shortcode('randombibleverse_arc', 'random_bible_verse_arc'); 

//sk
add_shortcode('bibleverseoftheday_sk', 'bible_verse_of_the_day_sk'); 
add_shortcode('randombibleverse_sk', 'random_bible_verse_sk'); 
add_shortcode('bibleverseoftheday_kat', 'bible_verse_of_the_day_kat'); 
add_shortcode('randombibleverse_kat', 'random_bible_verse_kat'); 

//it
add_shortcode('bibleverseoftheday_it', 'bible_verse_of_the_day_it'); 
add_shortcode('randombibleverse_it', 'random_bible_verse_it'); 
add_shortcode('bibleverseoftheday_cei', 'bible_verse_of_the_day_cei'); 
add_shortcode('randombibleverse_cei', 'random_bible_verse_cei'); 

//fr
add_shortcode('bibleverseoftheday_fr', 'bible_verse_of_the_day_fr'); 
add_shortcode('randombibleverse_fr', 'random_bible_verse_fr'); 
add_shortcode('bibleverseoftheday_sg21', 'bible_verse_of_the_day_sg21'); 
add_shortcode('randombibleverse_sg21', 'random_bible_verse_sg21'); 

//fi
add_shortcode('bibleverseoftheday_fi', 'bible_verse_of_the_day_fi'); 
add_shortcode('randombibleverse_fi', 'random_bible_verse_fi'); 
add_shortcode('bibleverseoftheday_kr92', 'bible_verse_of_the_day_kr92'); 
add_shortcode('randombibleverse_kr92', 'random_bible_verse_kr92'); 

//fi
add_shortcode('bibleverseoftheday_cuv', 'bible_verse_of_the_day_cuv'); 
add_shortcode('randombibleverse_cuv', 'random_bible_verse_cuv'); 

//fi
add_shortcode('bibleverseoftheday_avd', 'bible_verse_of_the_day_avd'); 
add_shortcode('randombibleverse_avd', 'random_bible_verse_avd'); 

//en
function bible_verse_of_the_day_niv() { return bible_verse_of_the_day('0', 'niv'); }
function random_bible_verse_niv() { return random_bible_verse('0', 'niv'); }
function bible_verse_of_the_day_kjv() { return bible_verse_of_the_day('0', 'kjv'); }
function random_bible_verse_kjv() { return random_bible_verse('0', 'kjv'); }
function bible_verse_of_the_day_esv() { return bible_verse_of_the_day('0', 'esv'); }
function random_bible_verse_esv() { return random_bible_verse('0', 'esv'); }

//nl
function bible_verse_of_the_day_nl() { return bible_verse_of_the_day('0', 'nbv'); }
function random_bible_verse_nl() { return random_bible_verse('0', 'nbv'); }
function bible_verse_of_the_day_nbv() { return bible_verse_of_the_day('0', 'nbv'); }
function random_bible_verse_nbv() { return random_bible_verse('0', 'nbv'); }
function bible_verse_of_the_day_bgt() { return bible_verse_of_the_day('0', 'bgt'); }
function random_bible_verse_bgt() { return random_bible_verse('0', 'bgt'); }
function bible_verse_of_the_day_nbg() { return bible_verse_of_the_day('0', 'nbg'); }
function random_bible_verse_nbg() { return random_bible_verse('0', 'nbg'); }
function bible_verse_of_the_day_bb() { return bible_verse_of_the_day('0', 'bb'); }
function random_bible_verse_bb() { return random_bible_verse('0', 'bb'); }

//es
function bible_verse_of_the_day_es() { return bible_verse_of_the_day('0', 'nvi'); }
function random_bible_verse_es() { return random_bible_verse('0', 'nvi'); }
function bible_verse_of_the_day_nvi() { return bible_verse_of_the_day('0', 'nvi'); }
function random_bible_verse_nvi() { return random_bible_verse('0', 'nvi'); }
function bible_verse_of_the_day_rvr60() { return bible_verse_of_the_day('0', 'rvr60'); }
function random_bible_verse_rvr60() { return random_bible_verse('0', 'rvr60'); }
function bible_verse_of_the_day_rvr95() { return bible_verse_of_the_day('0', 'rvr95'); }
function random_bible_verse_rvr95() { return random_bible_verse('0', 'rvr95'); }

//de
function bible_verse_of_the_day_de() { return bible_verse_of_the_day('0', 'lut'); }
function random_bible_verse_de() { return random_bible_verse('0', 'lut'); }
function bible_verse_of_the_day_lut() { return bible_verse_of_the_day('0', 'lut'); }
function random_bible_verse_lut() { return random_bible_verse('0', 'lut'); }
function bible_verse_of_the_day_neu() { return bible_verse_of_the_day('0', 'neu'); }
function random_bible_verse_neu() { return random_bible_verse('0', 'neu'); }
function bible_verse_of_the_day_elb() { return bible_verse_of_the_day('0', 'elb'); }
function random_bible_verse_elb() { return random_bible_verse('0', 'elb'); }

//pt
function bible_verse_of_the_day_pt() { return bible_verse_of_the_day('0', 'arc'); }
function random_bible_verse_pt() { return random_bible_verse('0', 'arc'); }
function bible_verse_of_the_day_arc() { return bible_verse_of_the_day('0', 'arc'); }
function random_bible_verse_arc() { return random_bible_verse('0', 'arc'); }

//sk
function bible_verse_of_the_day_sk() { return bible_verse_of_the_day('0', 'kat'); }
function random_bible_verse_sk() { return random_bible_verse('0', 'kat'); }
function bible_verse_of_the_day_kat() { return bible_verse_of_the_day('0', 'kat'); }
function random_bible_verse_kat() { return random_bible_verse('0', 'kat'); }

//it
function bible_verse_of_the_day_it() { return bible_verse_of_the_day('0', 'cei'); }
function random_bible_verse_it() { return random_bible_verse('0', 'cei'); }
function bible_verse_of_the_day_cei() { return bible_verse_of_the_day('0', 'cei'); }
function random_bible_verse_cei() { return random_bible_verse('0', 'cei'); }

//fr
function bible_verse_of_the_day_fr() { return bible_verse_of_the_day('0', 'fr'); }
function random_bible_verse_fr() { return random_bible_verse('0', 'fr'); }
function bible_verse_of_the_day_sg21() { return bible_verse_of_the_day('0', 'sg21'); }
function random_bible_verse_sg21() { return random_bible_verse('0', 'sg21'); }

//fi
function bible_verse_of_the_day_fi() { return bible_verse_of_the_day('0', 'fi'); }
function random_bible_verse_fi() { return random_bible_verse('0', 'fi'); }
function bible_verse_of_the_day_kr92() { return bible_verse_of_the_day('0', 'kr92'); }
function random_bible_verse_kr92() { return random_bible_verse('0', 'kr92'); }

//tc
function bible_verse_of_the_day_cuv() { return bible_verse_of_the_day('0', 'cuv'); }
function random_bible_verse_cuv() { return random_bible_verse('0', 'cuv'); }

//ar
function bible_verse_of_the_day_avd() { return bible_verse_of_the_day('0', 'avd'); }
function random_bible_verse_avd() { return random_bible_verse('0', 'avd'); }

function getLanguage() 
{
	$language = substr(get_locale(), 0, 2);
	$url = '/' . $language;
	
	if (get_language_url($language) == $url)
	{
		return $language;
	}
	
	return 'en';
}
  
class DailyVersesWidget extends WP_Widget
{
  function __construct() 
  {
	parent::__construct('DailyVersesWidget', __('Bible Verse of the Day', 'bible-verse-of-the-day'), array ('description' => __('Daily Bible verse from DailyVerses.net!', 'bible-verse-of-the-day')));
  }
    
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => __('Bible Verse of the Day', 'bible-verse-of-the-day'), 'showlink' => '0', 'language' => getLanguage() ) );
    $title = $instance['title'];
	$showlink = $instance['showlink'];
	$language = $instance['language'];
	
?>
  <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title', 'bible-verse-of-the-day') ?>: <br /><input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></label></p>
  <p><?php _e('Bible translation', 'bible-verse-of-the-day') ?>: <br /><select id="<?php echo $this->get_field_id('language'); ?>" name="<?php echo $this->get_field_name('language'); ?>">
	<option value="elb" <?php _e($language == 'elb' ? 'selected' : ''); ?>>Deutsch - ELB</option>
	<option value="de" <?php _e($language == 'de' || $language == 'lut' ? 'selected' : ''); ?>>Deutsch - LUT</option>
	<option value="neu" <?php _e($language == 'neu' ? 'selected' : ''); ?>>Deutsch - NeÜ</option>
	<option value="en" <?php _e($language == '' || $language == 'en' || $language == 'niv' ? 'selected' : ''); ?>>English - NIV</option>
	<option value="kjv" <?php _e($language == 'kjv' ? 'selected' : ''); ?>>English - KJV</option>
	<option value="esv" <?php _e($language == 'esv' ? 'selected' : ''); ?>>English - ESV</option>
	<option value="es" <?php _e($language == 'es' || $language == 'nvi' ? 'selected' : ''); ?>>Español - NVI</option>
	<option value="rvr60" <?php _e($language == 'rvr60' ? 'selected' : ''); ?>>Español - RVR60</option>
	<option value="rvr95" <?php _e($language == 'rvr95' ? 'selected' : ''); ?>>Español - RVR95</option>
	<option value="fr" <?php _e($language == 'fr' || $language == 'sg21' ? 'selected' : ''); ?>>Français - SG21</option>
	<option value="it" <?php _e($language == 'it' || $language == 'cei' ? 'selected' : ''); ?>>Italiano - CEI</option>
	<option value="nl" <?php _e($language == 'nl' || $language == 'nbv' ? 'selected' : ''); ?>>Nederlands - NBV</option>
	<option value="bgt" <?php _e($language == 'bgt' ? 'selected' : ''); ?>>Nederlands - BGT</option>
	<option value="nbg" <?php _e($language == 'nbg' ? 'selected' : ''); ?>>Nederlands - NBG</option>
	<option value="bb" <?php _e($language == 'bb' ? 'selected' : ''); ?>>Nederlands - BB</option>
	<option value="pt" <?php _e($language == 'pt' || $language == 'arc' ? 'selected' : ''); ?>>Português - ARC</option>
	<option value="sk" <?php _e($language == 'sk' || $language == 'kat' ? 'selected' : ''); ?>>Slovenský - KAT</option>
	<option value="fi" <?php _e($language == 'fi' || $language == 'kr92' ? 'selected' : ''); ?>>Suomi - KR92</option>
	<option value="cuv" <?php _e($language == 'cuv' ? 'selected' : ''); ?>>繁體中文 - CUV</option>
	<option value="avd" <?php _e($language == 'avd' ? 'selected' : ''); ?>>عربى - AVD</option>
  </select></p>
  <p><input id="<?php echo $this->get_field_id('showlink'); ?>" name="<?php echo $this->get_field_name('showlink'); ?>" type="checkbox" value="1" <?php checked( '1', $showlink ); ?>/><label for="<?php echo $this->get_field_id('showlink'); ?>">&nbsp;<?php _e('Show link to DailyVerses.net', 'bible-verse-of-the-day'); ?></label></p>
<?php
  }
 
  function update($new_instance, $old_instance)
  {
    $instance = $old_instance;
    $instance['title'] = $new_instance['title'];
	if(isset($new_instance['showlink']) && $new_instance['showlink'] == '1')
	{
		$instance['showlink'] = '1';
	}
	else
	{
		$instance['showlink'] = '0';
	}	
	if(!isset($new_instance['language']) || $new_instance['language'] == '')
	{
		$instance['language'] = 'en';
	}
	else
	{
		$instance['language'] = $new_instance['language'];
	}
    return $instance;
  }
 
  function widget($args, $instance)
  {
    extract($args, EXTR_SKIP);
 
    echo $before_widget;
    $title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
 
    if (!empty($title))
      echo $before_title . $title . $after_title;;
 
 	$showlink = $instance['showlink'];
	if($showlink == '')
	{
		$showlink = '1';
	}
	
	$language = $instance['language'];
	if($language == '')
	{
		$language = 'en';
	}
	
    echo bible_verse_of_the_day($showlink, $language);
 
    echo $after_widget; 
  } 
}

class RandomBibleVerseWidget extends WP_Widget
{
  function __construct() 
  {
	parent::__construct('RandomBibleVerseWidget', __('Random Bible verse', 'bible-verse-of-the-day'), array ('description' => __( 'Random Bible verse from DailyVerses.net!', 'bible-verse-of-the-day')));
  }
 
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => __('Random Bible verse', 'bible-verse-of-the-day'), 'showlink' => '0', 'language' => getLanguage() ) );
    $title = $instance['title'];
	$showlink = $instance['showlink'];
	$language = $instance['language'];
	
?>
  <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title', 'bible-verse-of-the-day') ?>: <br /><input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></label></p>
  <p><?php _e('Bible translation', 'bible-verse-of-the-day') ?>: <br /><select id="<?php echo $this->get_field_id('language'); ?>" name="<?php echo $this->get_field_name('language'); ?>">
	<option value="elb" <?php _e($language == 'elb' ? 'selected' : ''); ?>>Deutsch - ELB</option>
	<option value="de" <?php _e($language == 'de' || $language == 'lut' ? 'selected' : ''); ?>>Deutsch - LUT</option>
	<option value="neu" <?php _e($language == 'neu' ? 'selected' : ''); ?>>Deutsch - NeÜ</option>
	<option value="en" <?php _e($language == '' || $language == 'en' || $language == 'niv' ? 'selected' : ''); ?>>English - NIV</option>
	<option value="kjv" <?php _e($language == 'kjv' ? 'selected' : ''); ?>>English - KJV</option>
	<option value="esv" <?php _e($language == 'esv' ? 'selected' : ''); ?>>English - ESV</option>
	<option value="es" <?php _e($language == 'es' || $language == 'nvi' ? 'selected' : ''); ?>>Español - NVI</option>
	<option value="rvr60" <?php _e($language == 'rvr60' ? 'selected' : ''); ?>>Español - RVR60</option>
	<option value="rvr95" <?php _e($language == 'rvr95' ? 'selected' : ''); ?>>Español - RVR95</option>
	<option value="fr" <?php _e($language == 'fr' || $language == 'sg21' ? 'selected' : ''); ?>>Français - SG21</option>
	<option value="it" <?php _e($language == 'it' || $language == 'cei' ? 'selected' : ''); ?>>Italiano - CEI</option>
	<option value="nl" <?php _e($language == 'nl' || $language == 'nbv' ? 'selected' : ''); ?>>Nederlands - NBV</option>
	<option value="bgt" <?php _e($language == 'bgt' ? 'selected' : ''); ?>>Nederlands - BGT</option>
	<option value="nbg" <?php _e($language == 'nbg' ? 'selected' : ''); ?>>Nederlands - NBG</option>
	<option value="bb" <?php _e($language == 'bb' ? 'selected' : ''); ?>>Nederlands - BB</option>
	<option value="pt" <?php _e($language == 'pt' || $language == 'arc' ? 'selected' : ''); ?>>Português - ARC</option>
	<option value="sk" <?php _e($language == 'sk' || $language == 'kat' ? 'selected' : ''); ?>>Slovenský - KAT</option>
	<option value="fi" <?php _e($language == 'fi' || $language == 'kr92' ? 'selected' : ''); ?>>Suomi - KR92</option>
	<option value="cuv" <?php _e($language == 'cuv' ? 'selected' : ''); ?>>繁體中文 - CUV</option>
	<option value="avd" <?php _e($language == 'avd' ? 'selected' : ''); ?>>عربى - AVD</option>
  </select></p>
  <p><input id="<?php echo $this->get_field_id('showlink'); ?>" name="<?php echo $this->get_field_name('showlink'); ?>" type="checkbox" value="1" <?php checked( '1', $showlink ); ?>/><label for="<?php echo $this->get_field_id('showlink'); ?>">&nbsp;<?php _e('Show link to DailyVerses.net', 'bible-verse-of-the-day'); ?></label></p>
<?php
  }
 
  function update($new_instance, $old_instance)
  {
    $instance = $old_instance;
    $instance['title'] = $new_instance['title'];
	if(isset($new_instance['showlink']) && $new_instance['showlink'] == '1')
	{
		$instance['showlink'] = '1';
	}
	else
	{
		$instance['showlink'] = '0';
	}
	if(!isset($new_instance['language']) || $new_instance['language'] == '')
	{
		$instance['language'] = 'en';
	}
	else
	{
		$instance['language'] = $new_instance['language'];
	}
    return $instance;
  }
 
  function widget($args, $instance)
  {
    extract($args, EXTR_SKIP);
 
    echo $before_widget;
    $title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
 
    if (!empty($title))
      echo $before_title . $title . $after_title;;
 
 	$showlink = $instance['showlink'];
	if($showlink == '')
	{
		$showlink = '1';
	}
	
	$language = $instance['language'];
	if($language == '')
	{
		$language = 'en';
	}
	
    echo random_bible_verse($showlink, $language);
 
    echo $after_widget;
  }
}

function register_DailyVersesWidget() { 
  register_widget('DailyVersesWidget');
}


function register_RandomBibleVerseWidget() { 
  register_widget('RandomBibleVerseWidget');
}

add_action( 'widgets_init', 'register_DailyVersesWidget');
add_action( 'widgets_init', 'register_RandomBibleVerseWidget');
?>